# pd03.py (coding: cp932)
  # gƑ̏dɂāARނ̑֌WƎUz}Excelt@Cɏo
  # 摜̃^CgȂǂ{\L(IPÃtHg𗘗p)
import os, sys
import pandas as pd
import numpy as np
from scipy import stats
import matplotlib.pyplot as plt
import xlsxwriter

  # IPAtHg̑݊mFFontProperties̐ݒ
ttf_list = ['./IPAexfont00201/ipaexg.ttf',
  'C:/Users/Public/IPAexfont00201/ipaexg.ttf']
ttf_file = ''
for fpath in ttf_list:
    if os.path.isfile(fpath) == True:
        ttf_file = fpath
        break
if ttf_file == '':
    sys.stderr.write("IPÃtHg݂܂.\n")
    sys.exit(1)
from matplotlib.font_manager import FontProperties
fp = FontProperties(fname=ttf_file)

from platform import python_version
if int(python_version()[0]) < 3:
    reload(sys)
    sys.setdefaultencoding('cp932')  # ftHgR[hύX

xls_file = "pt_source.xls"
dtf = pd.read_excel(xls_file)
asc_col = ['ID', 'gender', 'height', 'weight']  # p̗񃉃x
dtf.columns = asc_col
dtf = dtf[dtf.height.notnull() & dtf.weight.notnull()]

  # Rނ̑֌W擾
p = stats.pearsonr(dtf.height, dtf.weight)
s = stats.spearmanr(dtf.height, dtf.weight)
k = stats.kendalltau(dtf.height, dtf.weight)
dtf2 = pd.DataFrame([p, s, k])
dtf2.columns = [u'֌W', 'p-value']
dtf2.index = ['pearson', 'spearman', 'kendall']

  # Uz}̍쐬(pngt@C)
image_file = "pd03.png"
plt.figure(figsize=(4.8, 3.6), dpi=100)
plt.scatter(dtf.height, dtf.weight)
plt.title(u"gƑ̏d̎Uz}", fontproperties=fp)
plt.xlabel(u"g", fontproperties=fp)
plt.ylabel(u"̏d", fontproperties=fp)
plt.savefig(image_file)

writer = pd.ExcelWriter('pd03.xlsx', engine='xlsxwriter')
dtf2.to_excel(writer, sheet_name='Sheet1')
worksheet = writer.sheets['Sheet1']
worksheet.insert_image(len(dtf2)+2, 0, image_file)
writer.save()
